	subroutine genbvar(n,nextra,im,k,np,rho,phi1,nq,theta,phi2,x)
c
c**********************************************************************
c
c   FORTRAN subroutine to generate a k-variate vector bilinear
c   process with autoregressive order np.  The cross-correlation of
c   the residuals is rho.
c
c   Input: n = an integer containing the number of observations for 
c              the desired realization.
c          nextra = an integer containing the number of extra realiza-
c                   tions to generate to remove the effects of the
c                   initial values.
c          im = an integer indiciating the type of cross-products
c               to use in generating the observations.
c               im = 2: use crossproducts of X and eps,
c               im = 3: use square and cross product of X.
c               im = 4: use square and cross product of eps.
c          k = an integer containing the number of time series.
c          np = an integer containing the order of the (linear) auto-
c               regressive part of the model.
c          rho = a double precision real scalar containing the corre-
c                lation between the errors.
c          phi1 = a double precision matrix of dimension k x k
c                 containing the coefficients for the (linear) auto-
c                 regressive part of the model.
c          nq = an integer containing the order of the (linear) moving
c               average part of the model.
c          theta = ***
c          phi2 = a double precision matrix of dimension k x (np*k)**2
c                 if im = 2,4 or (np*k)(np*k + 1)/2 if im = 3 
c                 containing the coefficients for the (nonlinear)  
c                 square and crossproduct terms.
c
c   Output: x = a double precision matrix of dimension n x k containing
c               the desired realization.
c
c   Accuracy: Implicit double precision (a-h, p-z)
c
c   Created: 7/19/97 Bonnie Ray
c   Modified: 7/28/97 Jane L. Harvill
c
c   Subprograms called: IMSL subroutine DCHFAC, IMSL subroutine DRNMVN,
c                       IMSL double precision function DMACH
c
c**********************************************************************
c
	parameter (nkmx = 5, nmx = 1200, npmx = 10)
	parameter (nqmx = (npmx*nkmx)**2)
 	implicit double precision (a-h, p-z)
c
	double precision cov(nkmx,nkmx),eps(nmx,nkmx),x(nmx,nkmx)
	double precision phi1(npmx,nkmx,nkmx),phi2(nkmx,(npmx*nkmx)**2)
	double precision zv(npmx*nkmx),zvt(1,npmx*nkmx)
	double precision z((npmx*nkmx)**2),theta(npmx,nkmx,nkmx)
c       
c	external DCHFAC, DRNMVN, DMACH
c
c   Set covariance matrix (cov):
c
	do i = 1,k
	do j = 1,k
	   if(i.eq.j) then
	      cov(i,j) = 1.0d0
	   else
	      cov(i,j) = rho
	   endif
	enddo
	enddo
c
c   Use IMSL subroutines.
c
c   The subroutine DCHFAC computes an upper triangular factorization
c   of a real symmetric nonnegative definite matrix.  The result is 
c   returned in the matrix cov.
c
c   The subroutine DRNMVN generates pseudorandom numbers from a 
c   multivariate normal distribution.  The result is returned in the
c   vector eps.
c
	call DCHFAC(k,cov,nkmx,100*dmach(4),irank,cov,nkmx)
	call DRNMVN(n+nextra,k,cov,nkmx,eps,nmx)
c
c   Generate realization:
c
	do i = 1,n+nextra
	   do ii=1,k
	      x(i,ii) = eps(i,ii)
	   enddo
c
c       Get cross products.  
c       If im.eq.2 then a realization from crossproducts of X's and
c         epsilon's is requested.
c	  If im.eq.3, model requested was squared terms and interactions
c       of time series.
c       If im.eq.4, model requested was squares and cross-products 
c       of epsilons.
c
	   do l = 1,k
	      do j = 1,min(i-1,np)
		 iindex1 = i - j
		 iindex2 = np*(l-1) + j
		 if(im.eq.2) then
		    zv(iindex2) = x(iindex1,l)
		    zvt(1,iindex2) = eps(iindex1,l)
		    iopt = 1
		 endif
		 if(im.eq.3) then
		    zv(iindex2) = x(i-j,l)
		    zvt(1,iindex2) = zv(np*(l-1)+j)
		    iopt = 0
		 endif
		 if(im.eq.4) then
		    zv(iindex2) = eps(iindex1,l)
		    zvt(1,iindex2) = zv(iindex2)
		    iopt = 0
		 endif
		 call vech(zv,zvt,npmx*nkmx,np*k,1,1,np*k,iopt,z)
	      enddo
	   enddo
c
c   Generate realization:first the linear terms are added, then the 
c   non-linear.
c
	   do j = 1,min(i-1,np)
	      do l = 1,k
		 do m = 1,k
		    x(i,l) = x(i,l)+phi1(j,l,m)*x(i-j,m)
		 enddo
	      enddo
	   enddo
	   do j = 1, min(i-1,nq)
	      do l = 1,k
		 do m = 1,k
		    x(i,l) = x(i,l) - theta(j,l,m)*eps(i-j,m)
		 enddo
	      enddo
	   enddo
	   do l = 1,k
	      do m = 1,(np*k)**2
		 x(i,l) = x(i,l) + phi2(l,m)*z(m)
	      enddo
	   enddo
	enddo
c       
c   Return only the last n values of x(i,j)
c
	do i = 1,n
	do j = 1,k
	   x(i,j) = x(i+nextra,j)
	enddo
	enddo
c
	return
	end

